VERSION 5.00
Begin VB.Form SDK_USBm_EX 
   Caption         =   "SDK_USBm_Ex"
   ClientHeight    =   6405
   ClientLeft      =   8955
   ClientTop       =   5445
   ClientWidth     =   6690
   LinkTopic       =   "SDK_USBm_EX"
   ScaleHeight     =   6405
   ScaleWidth      =   6690
   Begin VB.Frame Frame4 
      Caption         =   "Triggering Mode"
      Height          =   1215
      Left            =   120
      TabIndex        =   13
      Top             =   3600
      Width           =   6375
      Begin VB.CommandButton btnSet 
         Caption         =   "Set"
         Height          =   255
         Left            =   5280
         TabIndex        =   19
         Top             =   840
         Width           =   975
      End
      Begin VB.OptionButton rdExternalRising 
         Caption         =   "External Trigger Edge(Rising)"
         Height          =   255
         Left            =   2520
         TabIndex        =   18
         Top             =   600
         Width           =   3015
      End
      Begin VB.OptionButton rdExternalFalling 
         Caption         =   "External Trigger Edge(Falling)"
         Height          =   255
         Left            =   2520
         TabIndex        =   17
         Top             =   360
         Width           =   3015
      End
      Begin VB.OptionButton rdSWTrigger 
         Caption         =   "SW Trigger"
         Height          =   255
         Left            =   240
         TabIndex        =   16
         Top             =   840
         Width           =   2175
      End
      Begin VB.OptionButton rdFreeRunNext 
         Caption         =   "Free Run Next"
         Height          =   255
         Left            =   240
         TabIndex        =   15
         Top             =   600
         Width           =   2055
      End
      Begin VB.OptionButton rdFreeRunPrev 
         Caption         =   "Free Run Previous"
         Height          =   255
         Left            =   240
         TabIndex        =   14
         Top             =   360
         Width           =   2055
      End
   End
   Begin VB.ComboBox cbModelList 
      Height          =   300
      ItemData        =   "SDK_USBm_EX.frx":0000
      Left            =   2760
      List            =   "SDK_USBm_EX.frx":0013
      TabIndex        =   12
      Text            =   "Select Model"
      Top             =   600
      Width           =   3495
   End
   Begin VB.Frame Frame2 
      Caption         =   "Data Acquisition"
      Height          =   1215
      Left            =   120
      TabIndex        =   7
      Top             =   5040
      Width           =   6375
      Begin VB.CheckBox chAutoDark 
         Caption         =   "Auto Dark"
         Height          =   180
         Left            =   240
         TabIndex        =   20
         Top             =   360
         Width           =   1815
      End
      Begin VB.CommandButton current_data 
         Caption         =   "GetDataCurrent"
         Height          =   375
         Left            =   3840
         TabIndex        =   9
         Top             =   240
         Width           =   2295
      End
      Begin VB.CommandButton Graph_view 
         Caption         =   "10 View Current Chn"
         Height          =   375
         Left            =   3840
         TabIndex        =   8
         Top             =   720
         Width           =   2295
      End
   End
   Begin VB.TextBox Integration_time 
      BeginProperty DataFormat 
         Type            =   0
         Format          =   "0"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1042
         SubFormatType   =   0
      EndProperty
      Height          =   375
      IMEMode         =   3  ' 
      Left            =   4440
      TabIndex        =   5
      Text            =   "25"
      Top             =   2760
      Width           =   1935
   End
   Begin VB.TextBox ChannelsText 
      BackColor       =   &H8000000B&
      Height          =   375
      Left            =   2760
      Locked          =   -1  'True
      TabIndex        =   3
      Top             =   2280
      Width           =   3615
   End
   Begin VB.CommandButton check_channels 
      Caption         =   "Check Channels"
      Height          =   375
      Left            =   240
      TabIndex        =   2
      Top             =   2280
      Width           =   2415
   End
   Begin VB.TextBox ConnectionText 
      BackColor       =   &H8000000B&
      Height          =   375
      Left            =   2760
      Locked          =   -1  'True
      TabIndex        =   1
      Top             =   1800
      Width           =   3615
   End
   Begin VB.CommandButton check_connections 
      Caption         =   "Check Connections"
      Height          =   375
      Left            =   240
      TabIndex        =   0
      Top             =   1800
      Width           =   2415
   End
   Begin VB.Frame Frame1 
      Caption         =   "Channel Configuration"
      Height          =   1935
      Left            =   120
      TabIndex        =   4
      Top             =   1440
      Width           =   6375
      Begin VB.Label Label3 
         Caption         =   "Integration Time : "
         Height          =   255
         Left            =   2520
         TabIndex        =   6
         Top             =   1320
         Width           =   1695
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   "Device Infomation"
      Height          =   975
      Left            =   120
      TabIndex        =   10
      Top             =   240
      Width           =   6375
      Begin VB.Label Label2 
         Caption         =   "Model :"
         Height          =   255
         Left            =   1680
         TabIndex        =   11
         Top             =   360
         Width           =   855
      End
   End
End
Attribute VB_Name = "SDK_USBm_EX"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit


' MsgBox parameters

Const MB_ICONEXCLAMATION = 48   ' Warning message

Const TECON = 1
Const TECOFF = 0

Dim WLTableArray() As Double
Dim DataArray() As Long
Public bExtTrigger As Boolean
Public nTOTPixelNo As Integer, nRealPixelNo As Integer, EffectivePixelIndex As Integer
Public xInterval As Integer
Public sModel As String





Private Sub Form_Load()

Dim sRtn


check_channels.Enabled = False
current_data.Enabled = False
Graph_view.Enabled = False
Integration_time.Enabled = False

btnSet.Enabled = False
rdFreeRunPrev.Enabled = False
rdFreeRunNext.Enabled = False
rdSWTrigger.Enabled = False
rdExternalFalling.Enabled = False
rdExternalRising.Enabled = False
chAutoDark.Enabled = False

bExtTrigger = False

End Sub


'********************************************************************************************
'**                                                                                        **
'**        Function      : check_connections_Click()                                       **
'**        Description   : Spectrometer  Ȯ                                        **
'**        DLL Fuction   : spTestAllChannels(ByVal sOrderType As Integer)                  **
'********************************************************************************************

Private Sub check_connections_Click()
    
    Dim sRtn As Integer
   
    sRtn = spTestAllChannels(0) ''''''''''''''''''''''''''''''''''''''''''''''''''DLL Function : spTestAllChannels  0:SP_ORDER_BY_USBPORTNUM
    
    If (sRtn > 0) Then
    
        ConnectionText.Text = "Testing the USB board... OK!"
        
        check_channels.Enabled = True
        Integration_time.Enabled = True
        
    Else: ConnectionText.Text = "The USB board does not work correctly."
    
    End If

End Sub



'*****************************************************************************************************
'**                                                                                                 **
'**        Function      : check_channels_Click()                                                   **
'**        Description   :  Spectrometer setupϰ InitializeѴ                           **
'**        DLL Function  : spSetupGivenChannel(ByVal sChannel As Integer)                           **
'**                        spInitGivenChannel(ByVal sCCDType As Integer, ByVal sChannel As Integer) **
'**                        spGetWLTable(WLArray As Double, ByVal sChannel As Integer)               **
'*****************************************************************************************************
Private Sub check_channels_Click()
    
    Dim sRtn As Integer
    Dim SpType As Integer
    
   sModel = cbModelList.Text
   
   sRtn = spSetupAllChannels    '''''''''''''''''''''''''''''DLL Function : spSetupGivenChannel
    
    
    If (sRtn > 0) Then
            
        ChannelsText.Text = " Setup Channels...OK!"
        
        current_data.Enabled = True
        Graph_view.Enabled = True
        
        btnSet.Enabled = True
        rdFreeRunPrev.Enabled = True
        rdFreeRunNext.Enabled = True
        rdSWTrigger.Enabled = True
        rdExternalFalling.Enabled = True
        rdExternalRising.Enabled = True
        chAutoDark.Enabled = True
        
        rdFreeRunPrev.value = True
        
        If (sModel = "SM24X") Then
            nTOTPixelNo = 2080                ''''''''''''''''''''D1~D10 + S1~S2048 + D11~D20
            nRealPixelNo = 2048
            EffectivePixelIndex = 32
            SpType = 0
            xInterval = 600
        
        ElseIf (sModel = "SM44X") Then
            nTOTPixelNo = 3680                ''''''''''''''''''''D1~D32 + S1~S3648
            nRealPixelNo = 3648
            EffectivePixelIndex = 32
            SpType = 1
            xInterval = 1890
            
        ElseIf (sModel = "SM303") Then
            nTOTPixelNo = 1056                '''''''''''''''''''D1~D10 + S1~S1024 + D11~D20
            nRealPixelNo = 1024
            EffectivePixelIndex = 10
            SpType = 2
            spSetTEC TECON, 0              '''''''''''''''''''''''''DLL Function : spSetTEC   SM303 TEC On
            xInterval = 150
            
        ElseIf (sModel = "SM642") Then
            nTOTPixelNo = 2080                ''''''''''''''''''''D1~D10 + S1~S2048 + D11~D20
            nRealPixelNo = 2048
            EffectivePixelIndex = 10
            SpType = 4
            xInterval = 600
            
        ElseIf (sModel = "SM303-2048") Then
            nTOTPixelNo = 2080                ''''''''''''''''''''D1~D10 + S1~S2048 + D11~D20
            nRealPixelNo = 2048
            EffectivePixelIndex = 10
            SpType = 6
            xInterval = 600
            
        Else: MsgBox "Not Seleted Model"
              ChannelsText.Text = " Setup Channels...Error!"
              current_data.Enabled = False
              Graph_view.Enabled = False
              sRtn = -1
            
            
        End If
        
        If (sRtn > 0) Then
            ReDim DataArray(nTOTPixelNo)        ''''''''''''''' DataArray Mem Allocation
            ReDim WLTableArray(nRealPixelNo)    ''''''''''''''' Wavelenth Table Mem Allocation
            sRtn = spInitAllChannels(SpType) '''''''''''''''''''''''DLL Function : spInitGivenChannel    iType=1:SP_CCD_TOSHIBA, 2:SM303, 4:SM642
            sRtn = spGetWLTable(WLTableArray(0), 0)
            
        End If
       
    Else: ChannelsText.Text = " Setup Channels...Error!"
    
    End If
        

End Sub




'**********************************************************************************************
'**                                                                                          **
'**        Fuction       : current_data_Click()                                              **
'**        Description   : Ŭ   ѹ ȹϿ ȼѹ, , Intensity  **
'**                        SDK_Data.txt Ѵ.                                          **
'**        DLL Function  : spSetDblIntEx(ByVal dIntTime As Double, ByVal sChannel As Integer)**
'**                        spReadDataEx(lpArray As Long, ByVal sChannel As Integer)          **
'**********************************************************************************************

Private Sub current_data_Click()

Dim sRtn As Integer, i As Double
Dim IntTime As Long


Dim SaveFile$, Temp$, Temp1$, Temp2$, Temp3$

SaveFile = FreeFile

IntTime = Integration_time.Text

sRtn = spSetIntEx(IntTime, 0)                    ''''''''''''''''''''''''''''''''''''''''DLL Function : Integration Time Set
    
If (bExtTrigger) Then
    sRtn = 99
    
    Do While (sRtn = 99)
        sRtn = spReadDataEx(DataArray(0), 0)                '''''''''''''''''''''''''''''''''''''DLL Function : Data Capture
    Loop
Else:
    sRtn = spReadDataEx(DataArray(0), 0)                '''''''''''''''''''''''''''''''''''''DLL Function : Data Capture
    
End If

  
Open "SDK_Data.txt" For Output As #SaveFile         '''''''''''''''''''''''''''''''''''''Save SDK_Data.txt
Temp$ = "Index" & vbTab & "WL" & vbTab & "Intensity"
    Print #SaveFile, Temp$
 
For i = 0 To (nRealPixelNo - 1)
 
    Temp1$ = Format$(i + 1, "###0")
    Temp2$ = Format$(WLTableArray(i), "###0.0")
    Temp3$ = Format$(DataArray(i + EffectivePixelIndex), "###0.0")
    Temp$ = Temp1$ & vbTab & Temp2$ & vbTab & Temp3$
        
    Print #SaveFile, Temp$
Next i
  
Close #SaveFile
  
MsgBox "SDK_Data.txt" + " Saved", MB_ICONEXCLAMATION, "Save"



End Sub


'**********************************************************************************************
'**                                                                                          **
'**        Function     : Graph_view_Click()                                                 **
'**        Description  : ư Ŭ Data ׷ 100 ش.                        **
'**        DLL Function : spSetDblIntEx(ByVal dIntTime As Double, ByVal sChannel As Integer) **
'**                       spReadDataEx(lpArray As Long, ByVal sChannel As Integer)           **
'**                                                                                          **
'**********************************************************************************************

Private Sub Graph_view_Click()
    
    Dim sRtn As Integer
        
    Dim IntTime As Integer
        
   
    
    IntTime = Integration_time.Text
    
    sRtn = spSetIntEx(IntTime, 0) '''''''''''''''''''''''''''''''''''''''''''''''''''''''DLL Function : spSetIntEx
          
    GraphForm.Show
        
End Sub


Private Sub Form_Unload(Cancel As Integer) ''''''''''''''''''''''''''''''''''''''''''''''߰ Form_Unload

    If (sModel = "SM303") Then
        spSetTEC TECOFF, 0
    End If
    
    spCloseAllChannels

End

End Sub

Private Sub btnSet_Click()
    
    Dim sRtn As Integer
    Dim IntTime As Double
    
    IntTime = Integration_time.Text
    
    sRtn = spGetDevIsNew(0)
    
    bExtTrigger = False
    
    If (sRtn = 1) Then
        If (rdFreeRunPrev.value) Then
            sRtn = spSetIntMode(1, IntTime, 0)
        ElseIf (rdFreeRunNext.value) Then
            sRtn = spSetIntMode(2, IntTime, 0)
        ElseIf (rdSWTrigger.value) Then
            sRtn = spSetIntMode(0, IntTime, 0)
        ElseIf (rdExternalFalling.value) Then
            bExtTrigger = True
            sRtn = spSetExtEdgeMode(0, 0)
        ElseIf (rdExternalRising.value) Then
            bExtTrigger = True
            sRtn = spSetExtEdgeMode(1, 0)
        End If
    Else:
        If (rdFreeRunPrev.value) Then
            sRtn = spSetTrgEx(11, 0)
        ElseIf (rdFreeRunNext.value Or rdSWTrigger.value) Then
            MsgBox prompt:="The device does not support", Buttons:=vbExclamation
        ElseIf (rdExternalFalling.value) Then
            bExtTrigger = True
            sRtn = spSetTrgEx(12, 0)
        ElseIf (rdExternalRising.value) Then
            MsgBox prompt:="The device does not support", Buttons:=vbExclamation
        End If
    End If


End Sub
Private Sub chAutoDark_Click()

    Dim sRtn As Integer
    
    If (chAutoDark.value) Then
        sRtn = spAutoDark(1, 0)
    Else:
        sRtn = spAutoDark(0, 0)
    End If
End Sub
